/****************************************************************************
  File          : RotarySwitch_Includes.h
-----------------------------------------------------------------------------
  Author        : Ralf Hornung

                  Hilscher GmbH,  Copyright (c) 2010
                  All Rights Reserved

                  Redistribution or unauthorized use without expressed written
                  agreement from the Author is forbidden

  Date          : 15-Okt-2010

  Project       : rcX - realtime communication-system for netX netX
-----------------------------------------------------------------------------
  Description:

    - Provides funktions to configure and read switch for address and baudrate

  Functions:

    None

-----------------------------------------------------------------------------
  Todo:
-----------------------------------------------------------------------------
  Changes:

    Version   Date        Author  Description
    ----------------------------------------------------------------------------------
    1        15.10.2010   RH      created

****************************************************************************/
#ifndef __ROTARYSWITCH_INCLUDES_H
#define __ROTARYSWITCH_INCLUDES_H

#include "TLR_INX_Includes.h"
#include "rx_TagLists.h"
#include "AP_I2c.h"

#define SW_TYPE_HIFPIO    1         /* Switch is connected to HIFPIO          */
#define SW_TYPE_PIO       2         /* Switch is connected to PIO             */
#define SW_TYPE_GPIO      3         /* Switch is connected to GPIO            */
#define SW_TYPE_MMIO      4         /* Switch is connected to MMIO            */
#define SW_TYPE_I2C       5         /* Switch is connected to I2C             */
#define SW_TYPE_SHIFTREG  6         /* Switch is connected to shift register  */
                                    /* other values are reserved              */

#define SW_MODE_BCD    1            /* BCD mode                               */
#define SW_MODE_BCDI   2            /* BCD mode, inverted                     */
#define SW_MODE_HEX    3            /* Hexadecimal mode                       */
#define SW_MODE_HEXI   4            /* Hexadecimal mode, inverted             */
                                    /* other values are reserved              */
typedef struct
{
  TLR_UINT8  abSWName[16];          /* switch name (i.e. SW_BAUD_RATE, ...  */
  TLR_UINT32 ulSWType;              /* type of the switch (HIF, PIO, GPIO ..) */
  TLR_UINT32 ulSWMode;              /* mode of the switch (BCD, HEX, BIN ...  */

    /* the additional parameter can be used */
    /* switch type specific: i.e. PIN Nr.,  */
    /* I2C Address, Mode, Order etc.  */

  TLR_UINT8  bSWPin1;               /* first pin number where the switch      */
  /* is connected to  */
  TLR_UINT8  bSWPinNum;             /* number of pins used for the switch     */
  TLR_UINT8  bSWPinOrder;           /* flag: ascending/descending pin order   */
  TLR_UINT8  bReserved0;            /* Reserved                               */
  TLR_UINT32 ulReserved1;           /* Reserved for switch spec. parameter    */
  TLR_UINT32 ulReserved2;           /* Reserved for switch spec. parameter    */
  TLR_UINT32 ulReserved3;           /* Reserved for switch spec. parameter    */
  TLR_UINT32 ulReserved4;           /* Reserved for switch spec. parameter    */
} RCX_TAG_SWITCH_DATA_T;

typedef struct
{
  RCX_TAG_HEADER_T  tHeader;
  RCX_TAG_SWITCH_DATA_T tData;
} RCX_TAG_SWITCH_T;

typedef struct
{
  TLR_UINT32 ulSWMode;              /* mode of the switch (BCD, HEX, BIN ...  */

    /* the additional parameter can be used */
    /* switch type specific: i.e. PIN Nr.,  */
    /* I2C Address, Mode, Order etc.  */

  TLR_UINT8  bSWPin1;               /* first pin number where the switch      */
  /* is connected to  */
  TLR_UINT8  bSWPinNum;             /* number of pins used for the switch     */
  TLR_UINT8  bSWPinOrder;           /* flag: ascending/descending pin order   */
  TLR_UINT8  bReserved0;            /* Reserved                               */
  TLR_UINT32 ulReserved1;           /* Reserved for switch spec. parameter    */
  TLR_UINT32 ulReserved2;           /* Reserved for switch spec. parameter    */
  TLR_UINT32 ulReserved3;           /* Reserved for switch spec. parameter    */
  TLR_UINT32 ulReserved4;           /* Reserved for switch spec. parameter    */

}ROTARYSWITCH_DEFAULT_CONFIG_PARAMETER_T;

typedef struct ROTARYSWITCH_HIFPIO_CONFIG_PARAMETER_Ttag
{
  TLR_UINT32 ulSWMode;              /* mode of the switch (BCD, HEX, BIN ...  */
  TLR_UINT8  bSWPin1;               /* first pin number where the switch      */
  /* is connected to  */
  TLR_UINT8  bSWPinNum;             /* number of pins used for the switch     */
  TLR_UINT8  bSWPinOrder;           /* flag: ascending/descending pin order   */

}ROTARYSWITCH_HIFPIO_CONFIG_PARAMETER_T;

typedef struct ROTARYSWITCH_MMIO_CONFIG_PARAMETER_Ttag
{
  TLR_UINT32 ulSWMode;              /* mode of the switch (BCD, HEX, BIN ...  */
  TLR_UINT8  bSWPin1;               /* first pin number where the switch      */
  /* is connected to  */
  TLR_UINT8  bSWPinNum;             /* number of pins used for the switch     */
  TLR_UINT8  bSWPinOrder;           /* flag: ascending/descending pin order   */
}ROTARYSWITCH_MMIO_CONFIG_PARAMETER_T;

typedef struct ROTARYSWITCH_I2C_CONFIG_PARAMETER_Ttag
{
  TLR_UINT32 ulSWMode;              /* mode of the switch (BCD, HEX, BIN ...  */
  TLR_UINT8  bSWPin1;               /* first pin number where the switch      */
  /* is connected to  */
  TLR_UINT8  bSWPinNum;             /* number of pins used for the switch     */
  TLR_UINT8  bSWPinOrder;           /* flag: ascending/descending pin order   */
  TLR_UINT8  bSlaveAddr;            /* I2C Slave address                      */
}ROTARYSWITCH_I2C_CONFIG_PARAMETER_T;

typedef struct ROTARYSWITCH_I2C_RESSOURCE_Ttag
{
  ROTARYSWITCH_I2C_CONFIG_PARAMETER_T tParam;
  TLR_HANDLE hI2CHandle;
  RX_I2C_DEVICE_T tI2CDevice;
}ROTARYSWITCH_I2C_ROTARYSWITCH_I2C_RESSOURCE_T;

typedef union
{
  ROTARYSWITCH_DEFAULT_CONFIG_PARAMETER_T tDefault;
  ROTARYSWITCH_MMIO_CONFIG_PARAMETER_T    tMmio;
  ROTARYSWITCH_HIFPIO_CONFIG_PARAMETER_T  tHifPio;
  ROTARYSWITCH_I2C_CONFIG_PARAMETER_T     tI2c;
}ROTARYSWITCH_CONFIG_PARAMETER_T;

typedef TLR_UINT32(* ROTARYSWITCH_GET_FKT_T)(TLR_VOID * pvParam);
typedef TLR_VOID(* ROTARYSWITCH_DEINIT_FKT_T)(TLR_VOID * pvParam);
typedef TLR_RESULT(* ROTARYSWITCH_INIT_FKT_T)(ROTARYSWITCH_GET_FKT_T * ptGetFkt, ROTARYSWITCH_DEINIT_FKT_T * ptDeinitFkt, ROTARYSWITCH_CONFIG_PARAMETER_T * ptSwParam, TLR_VOID ** ppvParam);

TLR_UINT32  RotarySwitch_GetFromHifPio  ( TLR_VOID * pvParam);
TLR_VOID    RotarySwitch_DeinitHifPio   ( TLR_VOID * pvParam);
TLR_RESULT  RotarySwitch_InitHifPio     ( ROTARYSWITCH_GET_FKT_T * pfncGetSwitch,
                                          ROTARYSWITCH_DEINIT_FKT_T * pfncDeinitSwitch,
                                          ROTARYSWITCH_CONFIG_PARAMETER_T * ptSwitchParam,
                                          TLR_VOID ** ppvParam );


TLR_UINT32  RotarySwitch_GetFromMmio  ( TLR_VOID * pvParam );
TLR_VOID    RotarySwitch_DeinitMmio   ( TLR_VOID * pvParam );
TLR_RESULT  RotarySwitch_InitMmio     ( ROTARYSWITCH_GET_FKT_T * pfncGetSwitch,
                                        ROTARYSWITCH_DEINIT_FKT_T * pfncDeinitSwitch,
                                        ROTARYSWITCH_CONFIG_PARAMETER_T * ptSwitchParam,
                                        TLR_VOID ** ppvParam );

TLR_UINT32  RotarySwitch_GetFromI2c  ( TLR_VOID * pvParam );
TLR_VOID    RotarySwitch_DeinitI2c   ( TLR_VOID * pvParam );
TLR_RESULT  RotarySwitch_InitI2c     ( ROTARYSWITCH_GET_FKT_T * pfncGetSwitch,
                                       ROTARYSWITCH_DEINIT_FKT_T * pfncDeinitSwitch,
                                       ROTARYSWITCH_CONFIG_PARAMETER_T * ptSwitchParam,
                                       TLR_VOID ** ppvParam );



#endif /* #ifndef __ROTARYSWITCH_INCLUDES_H */

